# -*- coding: utf-8 -*-

# Author/Copyright: fr33p0rt <fr33p0rt@protonmail.com>
# License: Freeware (licensed to use and redistribute)

import json
import re
import requests

from urllib.parse import urlparse
from urllib.parse import parse_qs

from bs4 import BeautifulSoup

class Bellesa:
    URL_ROOT = 'https://www.bellesa.co'
    URL_VIDEOS = 'https://www.bellesa.co/videos'
    URL_VIDEOSTREAM = 'https://s.bellesa.co/v/%s/%s.mp4'
    URL_SEARCH = 'https://www.bellesa.co/search?q=%s&type=videos'
    URL_FILTER = 'https://www.bellesa.co/videos?page=1&%s=%s'

    def _get_data(self, soup):
        data_str = '{}'
        for script in soup.find_all('script'):
            if 'window.__INITIAL_DATA__' in str(script):
                data_str = re.findall('{.*}', str(script))[0]
                break
        return json.loads(data_str)

    def get_video_pages(self, url):
        r = requests.get(url if url else self.URL_VIDEOS)
        soup = BeautifulSoup(r.text, features='html.parser')

        video_page_urls = []

        for video_page in soup.find_all('a'):
            if video_page.attrs.get('href') and re.match(r'/videos/\d+', video_page.attrs.get('href')):
                if '%s%s' % (self.URL_ROOT, video_page.attrs.get('href')) not in video_page_urls:
                    video_page_urls.append('%s%s' % (self.URL_ROOT, video_page.attrs.get('href')))

        data_all = self._get_data(soup)
        if 'videos' in data_all:
            data_videos = data_all['videos']
        else:
            data_videos = data_all['data']
        data_pagination = data_all['pagination']
        video_links = []

        for video_page_url in video_page_urls[:len(data_videos)]:
            id = int(video_page_url.split('/')[4])
            video_data = list(filter(lambda _: _['id'] == id, data_videos))[0]

            performers = list(map(lambda _: _['name'], video_data['performers']))
            studios = list(map(lambda _: _['name'], video_data['content_provider']))
            tags = video_data['tags'].split(',')

            video_links.append({'url': video_page_url, 'nam': video_data['title'], 'img': video_data['image'],
                                'dsc': video_data['description'], 'res': video_data['resolutions'],
                                'dur': video_data['duration'], 'cst': performers, 'std': studios, 'tgs': tags})
        next_page = None
        return video_links, next_page

    def get_filters(self, url):
        r = requests.get(url if url else self.URL_VIDEOS)
        soup = BeautifulSoup(r.text, features='html.parser')
        data_all = self._get_data(soup)
        return data_all['filters']

    def _get_video_streams(self, url):
        r = requests.get(url)
        soup = BeautifulSoup(r.text, features='html.parser')

        data_json = self._get_data(soup)
        video_streams = []

        for resolution in data_json['video']['resolutions'].split(',') if data_json['video']['resolutions'] else ('360', '480', '720'):
            video_streams.append({'url': self.URL_VIDEOSTREAM % (data_json['video']['source'], resolution),
                                  'res': int(resolution)})

        video_streams.sort(key=lambda _: _['res'], reverse=True)
        return video_streams

    def get_video_stream(self, url, cfg):
        factor = 1000
        for video_stream in self._get_video_streams(url):
            if video_stream['res'] <= cfg['resolution'] % factor:
                return video_stream['url']
        return video_stream['url']

    def make_search_url(self, search):
        return self.URL_SEARCH % search

    def make_filter_url(self, type, handle):
        return self.URL_FILTER % (type, handle)
