# -*- coding: utf-8 -*-

# Author/Copyright: fr33p0rt <fr33p0rt@protonmail.com>
# License: Freeware (licensed to use and redistribute)

import requests
try:
    import xbmc
    import xbmcaddon
    import xbmcplugin
except:
    from unittest.mock import Mock
    from unittest.mock import MagicMock

    xbmc = Mock()
    xbmcaddon = Mock()
    xbmcplugin = Mock()

    xbmc.getCondVisibility = MagicMock(return_value=True)
    xbmc.getInfoLabel = MagicMock(return_value='99.99.99-test')
    xbmcaddon.Addon = MagicMock(return_value=MagicMock())
    xbmcaddon.Addon.return_value.getAddonInfo = MagicMock(return_value='test-run')
    xbmcaddon.Addon.return_value.getSetting = MagicMock(return_value='testtest')

class Anal():
    def report(self, event, detail, addon_details):
        success = False
        try:
            URL = 'https://api-eu.mixpanel.com/track#live-event'
            TEMPLATE = '{"event":"%s","properties":{"token":"7a4807bd2e44583fad5a744fea8acbde","detail":"%s","did":"%s","fla":"%s","ver":"%s","$os":"%s","$browser_version":"%s"}}'

            headers = {'Accept': 'text/plain', 'Content-Type': 'application/x-www-form-urlencoded'}
            payload = {'data': TEMPLATE % (event, detail, self.get_did(), addon_details['id'].split('.')[-1],
                                           addon_details['version'], self.get_opsy(),
                                           xbmc.getInfoLabel('System.BuildVersion')), 'ip': '1'}

            r = requests.post(URL, data=payload, headers=headers)
            xbmc.log(str(r.text), xbmc.LOGERROR)
            success = r.text == '1'
        except Exception as e:
            xbmc.log(str(e), xbmc.LOGERROR)
            pass
        return success

    def get_opsy(self):
        opsy = '?'
        if xbmc.getCondVisibility('system.platform.windows'):
            return 'W'
        if xbmc.getCondVisibility('system.platform.osx'):
            return 'O'
        if xbmc.getCondVisibility('system.platform.linux'):
            opsy = 'L'
            if xbmc.getCondVisibility('System.Platform.Android'):
                return 'A'
        return opsy

    def create_did(self):
        import random
        chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'
        did = (''.join([chars[random.randrange(len(chars))] for _ in range(8)]))
        return did

    def get_did(self):
        addon = xbmcaddon.Addon()
        did = addon.getSetting('did')
        if not did:
            did = self.create_did()
            addon.setSetting('did', did)
        return did

