﻿# -*- coding: utf-8 -*-

import sys
import re
import xbmc
import xbmcgui
import xbmcplugin
import json
import xbmcvfs
import time
from datetime import datetime, timedelta
PY2 = sys.version_info[0] == 2
if PY2:
	from urllib import urlencode  # Python 2.X
else: 
	from urllib.parse import urlencode  # Python 3.X

from .common import *


def mainMenu():
	addDir(translation(30601), icon, {'mode': 'listArticles', 'url': BASE_URL+'/video/', 'limit': '3'})
	addDir(translation(30602), icon, {'mode': 'listArticles', 'url': BASE_URL+'/thema/spiegel-tv/', 'limit': '-3'})
	addDir(translation(30603), icon, {'mode': 'listArticles', 'url': BASE_URL+'/panorama/', 'limit': '17'})
	addDir(translation(30604), icon, {'mode': 'listArticles', 'url': BASE_URL+'/ausland/', 'limit': '17'})
	addDir(translation(30605), icon, {'mode': 'listArticles', 'url': BASE_URL+'/politik/deutschland/', 'limit': '10'})
	addDir(translation(30606), icon, {'mode': 'listArticles', 'url': BASE_URL+'/thema/der-spiegel-liest-live/'})
	addDir(translation(30607), icon, {'mode': 'listArticles', 'url': BASE_URL+'/thema/spitzengespraech-der-talk-mit-markus-feldenkirchen/'})
	addDir(translation(30608), icon, {'mode': 'listArticles', 'url': BASE_URL+'/thema/spitzentitel-die-buechershow-mit-volker-weidermann/'})
	addDir(translation(30609), icon, {'mode': 'listArticles', 'url': BASE_URL+'/thema/auto-tests-im-video/'})
	addDir(translation(30610), icon, {'mode': 'listArticles', 'url': BASE_URL+'/thema/coronavirus-videos/', 'limit': '3'})
	if enableYOUTUBE:
		addDir(translation(30621), icon, {'mode': 'listYTcategories'})
	if enableADJUSTMENT:
		addDir(translation(30622), artpic+'settings.png', {'mode': 'aConfigs'}, folder=False)
		if enableINPUTSTREAM and ADDON_operate('inputstream.adaptive'):
			addDir(translation(30623), artpic+'settings.png', {'mode': 'iConfigs'}, folder=False)
	if not ADDON_operate('inputstream.adaptive'):
		addon.setSetting('useInputstream', 'false')
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listArticles(url, plusLIMIT):
	debug_MS("(navigator.listArticles) -------------------------------------------------- START = listArticles --------------------------------------------------")
	debug_MS("(navigator.listArticles) ### URL = {0} ### plusLIMIT = {1} ### PAGINATION = {2} ###".format(url, plusLIMIT, str(Pagination)))
	COMBI_PAGES, COMBI_ARTICLES, COMBI_LINKS, COMBI_MEDIA, COMBI_FIRST, COMBI_SECOND, COMBI_THIRD, COMBI_FOURTH = ([] for _ in range(8))
	RESULT_ONE, RESULT_TWO = (None for _ in range(2))
	counter = 0
	Isolated = set()
	for i in range(1, Pagination+int(plusLIMIT), 1):
		WLINK_1 = '{0}p{1}/'.format(url, str(i)) if int(i) > 1 else url
		debug_MS("(navigator.listArticles[1]]) SERIES-PAGES XXX POS = {0} || URL = {1} XXX".format(str(i), WLINK_1))
		COMBI_PAGES.append([int(i), WLINK_1, WLINK_1])
	if COMBI_PAGES:
		COMBI_ARTICLES = getMultiData(COMBI_PAGES)
		if COMBI_ARTICLES:
			#log("++++++++++++++++++++++++")
			#log("(navigator.listArticles[2]) no.02 XXXXX COMBI_ARTICLES-02 : {0} XXXXX".format(str(COMBI_ARTICLES)))
			#log("++++++++++++++++++++++++")
			for num, WLINK_2, DDURL_2, item in sorted(COMBI_ARTICLES, key=lambda k: int(k[0]), reverse=False):
				if item is not None:
					if WLINK_2.endswith('/video/'):
						results = re.findall(r'(?:<section class="relative flex flex-wrap w-full" data-size="full" data-first="true" data-area="block>topic|data-area="article-teaser-list")(.+?)(?:<section class="relative flex flex-wrap w-full"|data-area="pagination-bar")', item, re.S)
					else:
						results = re.findall(r'(?:<section class="relative flex flex-wrap w-full" data-size="full" data-first="true" data-area="block>topic|data-area="article-teaser-list")(.+?)data-area="pagination-bar"', item, re.S)
					for chtml in results:
						part = chtml.split('data-block-el="articleTeaser"')
						for i in range(1, len(part), 1):
							entry = part[i].replace('&#34;', '"')
							NOTE_1, START_1, DESC_1 = ("" for _ in range(3))
							NAV_1, TAGLINE_1, JSURL_1 = (None for _ in range(3))
							debug_MS("(navigator.listArticles[2]) no.02 ### ENTRY-02 : {0} ###".format(str(entry)))
							NAME = re.compile(r'<article aria-label="(.+?)" (?:data-|class=)', re.S).findall(entry)[0]
							TITLE_1 = cleaning(NAME)
							STREAM = re.compile('<a href="([^"]+?)" target=', re.S).findall(entry)
							NAV_1 = STREAM[0] if STREAM else None
							if NAV_1 is None or (NAV_1 and NAV_1 in Isolated):
								continue
							Isolated.add(NAV_1)
							# <img data-image-el="img" class="block lazyload h-full mx-auto" src= || <img data-video-el="poster" class="block lazyload h-full mx-auto" src=
							IMG = re.compile('<img data-(?:image|video)-el=".*?src="(https://cdn.prod.www.spiegel.de/images[^"]+?)"', re.S).findall(entry)
							THUMB_1 = IMG[-1].replace('_w300_r1.778_', '_w1200_r1.77_').replace('_w488_r1.778_', '_w1200_r1.77_') if IMG else ""
							THUMB_1 = THUMB_1.split('_fd')[0]+'.jpg' if '_fd' in THUMB_1 else THUMB_1
							# <span class="block text-primary-base focus:text-primary-darker hover:text-primary-dark font-sansUI font-bold text-base">
							# <span class="focus:text-primary-darker font-sansUI font-bold hover:text-primary-dark text-base mb-4 text-primary-base">
							TAG_1 = re.compile(r'(?:text-primary-(?:base|dark|darker) font-sansUI font-bold.*?text-base(?: mb-4 text-primary-base)?)">([^<]+?)</', re.S).findall(entry)
							TAGLINE_1 = cleaning(TAG_1[0]).replace('\n',' ').replace('\t',' ') if TAG_1 else None # Lauterbach und das Scholz-Team
							# <footer class="font-sansUI text-shade-dark text-s"> || <span class="font-sansUI font-normal text-s text-shade-dark"> || <span class="font-sansUI font-normal text-s text-shade-dark dark:text-shade-light">
							# <span class="font-sansUI font-normal lg:text-base md:text-s sm:text-s text-shade-dark"> || <span class="font-sansUI text-s text-shade-dark font-normal mt-2">
							STORY_1 = re.compile(r'(?:class="font-sansUI text-shade-dark text-s|class="font-sansUI font-normal.*?text-s text-shade-dark(?: dark:text-shade-light)?|class="font-sansUI text-s text-shade-dark font-normal mt-2)">(.+?)</', re.S).findall(entry) # Ein Video von Janita Hämäläinen
							STORY_2 = re.compile(r'<span data-auxiliary>(.+?Uhr)</', re.S).findall(entry) # 8. Dezember 2021, 12.50 Uhr
							if STORY_1 and not 'spitzengespraech' in WLINK_2 and not 'spitzentitel' in WLINK_2:
								NOTE_1 = translation(30624).format(cleaning(re.sub(r'\<.*?\>', '', STORY_1[0])))
							if STORY_2: START_1 = cleaning(STORY_2[0])
							# <span class="font-serifUI font-normal text-base leading-loose mr-6"> || <span class="font-serifUI font-normal lg:text-l md:text-base sm:text-base leading-loose mr-6">
							# <span class="font-serifUI text-base leading-loose"> || <span class="block font-serifUI text-base leading-loose sm:mr-16 mb-12"> 
							STORY_3 = re.compile(r'(?:class="font-serifUI font-normal.*?text-base leading-loose mr-6|class="(?:block )?font-serifUI text-base leading-loose(?: sm:mr-16 mb-12)?)">(.+?)</', re.S).findall(entry) # Beschreibung long
							if STORY_3: DESC_1 = cleaning(re.sub(r'\<.*?\>', '', STORY_3[0]))
							# </svg>\n</span>\n<span class="text-white dark:text-shade-lightest font-sansUI text-s font-bold">27:09</span>\n</span> || </svg>\n</span>\n<span>7 Min</span>\n</span>
							DUR_1 = re.compile('</svg>\s*</span>\s*<spa.+?>([^<]+?)</span>\s*</span>', re.S).findall(entry)
							DURATION_1 = get_Seconds(DUR_1[0].strip()) if DUR_1 else 0
							if not re.search(r'<span data-icon-auxiliary="Video">', entry): continue # KEIN Playsymbol gefunden im THUMB gefunden !!!
							JWID_1 = re.compile('data-component="Video" data-settings=.*?,"(?:jwplayerMedia|media)Id":"(.+?)",', re.S).findall(entry)
							JSURL_1 = 'https://vcdn01.spiegel.de/v2/media/{}?sources=hls,dash,mp4'.format(JWID_1[0]) if JWID_1 else None
							markID_1 = JWID_1[0] if JWID_1 else '00'
							counter += 1
							COMBI_FIRST.append([int(counter), markID_1, TITLE_1, THUMB_1, NAV_1, NOTE_1, START_1, DESC_1, DURATION_1, TAGLINE_1])
							if JSURL_1 is None and NAV_1:
								COMBI_LINKS.append([int(counter), NAV_1, NAV_1])
							elif JSURL_1 and NAV_1:
								COMBI_MEDIA.append([int(counter), NAV_1, JSURL_1])
	if COMBI_FIRST:
		COMBI_SECOND = listSubstances(COMBI_LINKS)
		RESULT_ONE = [a + b for a in COMBI_FIRST for b in COMBI_SECOND if a[4] == b[1]] # Zusammenführung von Liste1 und Liste2 - wenn der LINK überein stimmt !!!
		RESULT_ONE += [c for c in COMBI_FIRST if all(d[1] != c[4] for d in COMBI_SECOND)] # Der übriggebliebene Rest von Liste1 - wenn der LINK nicht in der Liste2 vorkommt !!!
	if COMBI_SECOND or COMBI_MEDIA:
		COMBI_THIRD = getMultiData(COMBI_SECOND+COMBI_MEDIA, WAY='JS')
		if COMBI_THIRD:
			DATA_TWO = json.loads(COMBI_THIRD)
			#log("++++++++++++++++++++++++")
			#log("(navigator.listArticles[4]) no.04 XXXXX DATA_TWO-04 : {0} XXXXX".format(str(DATA_TWO)))
			#log("++++++++++++++++++++++++")
			for elem in DATA_TWO:
				if elem is not None and 'playlist' in elem and elem.get('playlist', [])[0]:
					THUMB_2, AIRED_2 = (None for _ in range(2))
					START_2 = ""
					POS_2, NAV_2, DEM_2= elem['Position'], elem['NaviLink'], elem['Demand']
					SHORT = elem['playlist'][0]
					SECTION = {k:v for k,v in SHORT.items() if k[:6] != 'jwpseg'}
					debug_MS("(navigator.listArticles[4]) no.04 ### POS : {0} || NAVI : {1} || ELEM-04 : {2} ###".format(str(POS_2), NAV_2, SECTION))
					markID_2 = (SHORT.get('mediaid', '00') or '00')
					TITLE_2 = cleaning(SHORT['title'])
					if 'images' in SHORT and len(SHORT['images']) > 0:
						THUMB_2 = [vid.get('src', []) for vid in SHORT.get('images', {}) if vid.get('type', [])[:5] == 'image'][-1]
					THUMB_2 = (SHORT.get('image', '') or "") if THUMB_2 is None else THUMB_2
					if str(SHORT.get('pubdate', '')).isdigit():
						LOCALstart = get_Local_DT(datetime(1970, 1, 1) + timedelta(seconds=SHORT.get('pubdate')))
						START_2 = LOCALstart.strftime('%d{0}%m{0}%Y {1} %H{2}%M {3}').format('-', '•', ':', 'Uhr')
						AIRED_2 = LOCALstart.strftime('%d{0}%m{0}%Y').format('.')
					DESC_2 = (cleaning(SHORT.get('description', '')) or "")
					DURATION_2 = (SHORT.get('duration', 0) or 0)
					COMBI_FOURTH.append([int(POS_2), markID_2, TITLE_2, THUMB_2, NAV_2, AIRED_2, START_2, DESC_2, DURATION_2])
	if COMBI_FOURTH and RESULT_ONE:
		RESULT_TWO = [e + f for e in RESULT_ONE for f in COMBI_FOURTH if e[4] == f[4]] # Zusammenführung von Liste1 und Liste2 - wenn der LINK überein stimmt !!!
		#log("++++++++++++++++++++++++")
		#log("(navigator.listArticles[5]) no.05 XXXXX RESULT_TWO-05 : {0} XXXXX".format(str(RESULT_TWO)))
		#log("++++++++++++++++++++++++")
		for da in sorted(RESULT_TWO, key=lambda k: int(k[0]), reverse=False): # Liste1 = 0-12 oder 0-9|| Liste2 = 13-21 oder 10-18
			debug_MS("---------------------------------------------")
			debug_MS("(navigator.listArticles[5]) no.05 ### Anzahl = {0} || Eintrag : {1} ###".format(str(len(da)), str(da)))
			if len(da) > 19: ### Liste1+Liste2 ist grösser als Nummer:19 ###
				'''
				Liste-1_SHORT = num1, mediaId1, title1, pict1, link1, note1, start1, desc1, duration1, tagline1 = da[0], da[1], da[2], da[3], da[4], da[5], da[6], da[7], da[8], da[9]
				Liste-2_SHORT = num3, mediaId2, title2, pict2, link3, aired, start2, desc2, duration2 = da[10], da[11], da[12], da[13], da[14], da[15], da[16], da[17], da[18]
				Liste-1_LONG = num1, mediaId1, title1, pict1, link1, note1, start1, desc1, duration1, tagline1, num2, link2, mediaId2 = da[0], da[1], da[2], da[3], da[4], da[5], da[6], da[7], da[8], da[9], da[10], da[11], da[12]
				Liste-2_LONG = num3, mediaId2, title2, pict2, link3, aired, start2, desc2, duration2 = da[13], da[14], da[15], da[16], da[17], da[18], da[19], da[20], da[21]
				'''
				producer, start1, desc1, tagline = da[5], da[6], da[7], da[9]
				episID, name, image, begins, start2, desc2, duration = da[14], da[2], da[16], da[18], da[19], da[20], da[21]
			elif 14 <= len(da) <= 19: ### Liste1+Liste2 liegt zwischen Nummer:14-19 ###
				producer, start1, desc1, tagline = da[5], da[6], da[7], da[9]
				episID, name, image, begins, start2, desc2, duration = da[11], da[2], da[13], da[15], da[16], da[17], da[18]
			elif 11 <= len(da) <= 13: ### Liste1 liegt zwischen Nummer:11-13 und Liste2 ist AUS ###
				media1, name, image, producer, start1, desc1, duration, tagline, media2 = da[1], da[2], da[3], da[5], da[6], da[7], da[8], da[9], da[12]
				episID = media1 if media1 != '00' else media2.split('media/')[1].split('?sources')[0]
				begins = None
			elif len(da) <= 10: ### Liste1 ist kleiner als Nummer:11 und Liste2 ist AUS ###
				episID, name, image, producer, start1, desc1, duration, tagline = da[1], da[2], da[3], da[5], da[6], da[7], da[8], da[9]
				begins = None
			START_SOLO = start2 if 14 <= len(da) <= 22 and start2 != "" else start1
			STARTING = translation(30625).format(START_SOLO) if START_SOLO != "" else ""
			COMP_DESC = desc2 if 14 <= len(da) <= 22 and len(desc2) > len(desc1) else desc1
			uvz = '{0}?{1}'.format(HOST_AND_PATH, urlencode({'mode': 'playVideo', 'url': episID}))
			SIGN = '[CR]' if producer != "" or STARTING != "" else ""
			plot = producer+STARTING+SIGN+COMP_DESC
			debug_MS("(navigator.listArticles[5]) no.05 ##### POS : {0} || NAME : {1} || mediaID : {2} || TIME : {3} #####".format(str(da[0]), name, episID, START_SOLO))
			debug_MS("(navigator.listArticles[5]) no.05 ##### TAG : {0} || DURATION : {1} || THUMB : {2} #####".format(tagline, str(duration), image))
			for method in getSorting(): xbmcplugin.addSortMethod(ADDON_HANDLE, method)
			liz = xbmcgui.ListItem(name)
			if KODI_ov20:
				videoInfoTag = liz.getVideoInfoTag()
				videoInfoTag.setTitle(name)
				videoInfoTag.setTagLine(tagline)
				videoInfoTag.setPlot(plot)
				if duration: videoInfoTag.setDuration(int(duration))
				if begins: videoInfoTag.setDateAdded(begins)
				if begins: videoInfoTag.setFirstAired(begins)
				#if begins: videoInfoTag.setPremiered(begins)
				videoInfoTag.setGenres(['News'])
				videoInfoTag.setStudios(['Der Spiegel'])
				videoInfoTag.setMediaType('movie')
			else:
				info = {}
				info['Title'] = name
				info['Tagline'] = tagline
				info['Plot'] = plot
				if duration: info['Duration'] = duration
				if begins: info['Date'] = begins
				if begins: info['Aired'] = begins
				info['Genre'] = ['News']
				info['Studio'] = 'Der Spiegel'
				info['Mediatype'] = 'movie'
				liz.setInfo(type='Video', infoLabels=info)
			liz.setArt({'icon': icon, 'thumb': image, 'poster': image, 'fanart': defaultFanart})
			if image and useThumbAsFanart and image != icon and not artpic in image:
				liz.setArt({'fanart': image})
			liz.setProperty('IsPlayable', 'true')
			liz.setContentLookup(False)
			liz.addContextMenuItems([(translation(30654), 'RunPlugin({0}?{1})'.format(HOST_AND_PATH, 'mode=AddToQueue'))])
			xbmcplugin.addDirectoryItem(handle=ADDON_HANDLE, url=uvz, listitem=liz)
	else:
		debug_MS("(navigator.listArticles) ##### Keine ARTICLES-LIST - Kein Eintrag gefunden #####")
		return dialog.notification(translation(30521).format('WORK'), translation(30522), icon, 8000)
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def listSubstances(MURLS):
	COMBI_DETAILS, COMBI_INQUIRY = ([] for _ in range(2))
	COMBI_DETAILS = getMultiData(MURLS)
	if COMBI_DETAILS:
		for num, WLINK_4, DDURL_4, each in COMBI_DETAILS:
			if each is not None:
				each = each.replace('&#34;', '"')
				AREA = re.compile(r'<main id="Inhalt"(.+?)<div data-area="body">', re.S).findall(each)
				CONTENT = AREA[0] if AREA else each
				debug_MS("(navigator.listSubstances[3]) no.03 ### EACH-03 : {0} ###".format(str(CONTENT)))
				JWID_2 = re.compile('"(?:jwplayerMedia|media)Id":"(.+?)",', re.S).findall(each)
				JSURL_2 = 'https://vcdn01.spiegel.de/v2/media/{}?sources=hls,dash,mp4'.format(JWID_2[0]) if JWID_2 else None
				if JSURL_2 and DDURL_4:
					COMBI_INQUIRY.append([int(num), WLINK_4, JSURL_2])
	return COMBI_INQUIRY

def listYTcategories():
	debug_MS("(navigator.listYTcategories) -------------------------------------------------- START = listYTcategories --------------------------------------------------")
	addDir(translation(30631), icon, {'url': BASE_YT.format('UU1w6pNGiiLdZgyNpXUnA4Zw'), 'extras': 'YT_FOLDER'})
	addDir(translation(30632), icon, {'url': BASE_YT.format('PL54B134AD9A7A86C8'), 'extras': 'YT_FOLDER'})
	addDir(translation(30633), icon, {'url': BASE_YT.format('PLuiYhcgFTmqD24gcCDlpmGK75hIgjJXfl'), 'extras': 'YT_FOLDER'})
	addDir(translation(30634), icon, {'url': BASE_YT.format('PL8B9FDFC553E79FC6'), 'extras': 'YT_FOLDER'})
	addDir(translation(30635), icon, {'url': BASE_YT.format('PLuiYhcgFTmqDTfN9kw9H3u_lqBymi_kop'), 'extras': 'YT_FOLDER'})
	addDir(translation(30636), icon, {'url': BASE_YT.format('PLuiYhcgFTmqBmHD5Rnvu2IWdW3ZNlyF6N'), 'extras': 'YT_FOLDER'})
	addDir(translation(30637), icon, {'url': BASE_YT.format('PLuiYhcgFTmqCqURWOR9LfQPAIHkc9mRDv'), 'extras': 'YT_FOLDER'})
	addDir(translation(30638), icon, {'url': BASE_YT.format('PU1w6pNGiiLdZgyNpXUnA4Zw'), 'extras': 'YT_FOLDER'})
	addDir(translation(30639), icon, {'url': BASE_YT.format('PLuiYhcgFTmqCMQU0Tk7jXA8jp-Z7k1koZ'), 'extras': 'YT_FOLDER'})
	addDir(translation(30640), icon, {'url': BASE_YT.format('PLuiYhcgFTmqA72mlhLUzweIGU8Bk3oub8'), 'extras': 'YT_FOLDER'})
	addDir(translation(30641), icon, {'url': BASE_YT.format('PLuiYhcgFTmqCEzEfAa9eAoxQzEEmQW5XH'), 'extras': 'YT_FOLDER'})
	xbmcplugin.endOfDirectory(ADDON_HANDLE)

def playVideo(PLID):
	debug_MS("(navigator.playVideo) -------------------------------------------------- START = playVideo --------------------------------------------------")
	debug_MS("(navigator.playVideo) ### PLID = {0} ###".format(PLID))
	MEDIAS = [] # https://vcdn01.spiegel.de/v2/media/ed2L0yL7?sources=hls,dash,mp4
	STREAM, QUALITY, FINAL_URL = (False for _ in range(3))
	DATA = getUrl('https://vcdn01.spiegel.de/v2/media/{}?sources=hls,dash,mp4'.format(PLID))
	for source in DATA['playlist'][0]['sources']:
		debug_MS("(navigator.playVideo[1]) ORIGINAL ### SOURCE : {0} ###".format(str(source)))
		TYPE = source['type']
		VIDEO = source['file']
		if TYPE.lower() == 'video/mp4':
			HEIGHT = (source.get('height', 0) or 0)
			MEDIAS.append({'url': VIDEO, 'mimeType': TYPE.lower(), 'height': HEIGHT})
			MEDIAS = sorted(MEDIAS, key=lambda h: int(h['height']), reverse=True)
			debug_MS("(navigator.playVideo[2]) MP4 ### SORTED_LIST : {0} ###".format(str(MEDIAS)))
		if (prefSTREAM == '0' or enableINPUTSTREAM) and TYPE.lower() == 'application/vnd.apple.mpegurl':
				debug_MS("(navigator.playVideo[3]) ~~~~~ TRY NUMBER ONE TO GET THE FINALURL (m3u8) ~~~~~")
				STREAM = 'HLS' if enableINPUTSTREAM else 'M3U8'
				MIME, QUALITY, FINAL_URL = 'application/vnd.apple.mpegurl', 'AUTO', VIDEO
	if not FINAL_URL and MEDIAS:
		for item in MEDIAS:
			if prefSTREAM == '1' and not enableINPUTSTREAM and item['height'] == prefQUALITY:
				debug_MS("(navigator.playVideo[4]) ~~~~~ TRY NUMBER TWO TO GET THE FINALURL (mp4) ~~~~~")
				STREAM, MIME, QUALITY, FINAL_URL = 'MP4', 'video/mp4', str(item['height'])+'p', item['url']
	if not FINAL_URL and MEDIAS:
		log("(navigator.playVideo[5]) !!!!! KEINEN passenden Stream gefunden --- nehme jetzt den Reserve-Stream-MP4 !!!!!")
		STREAM, MIME, QUALITY, FINAL_URL = 'MP4', 'video/mp4', str(MEDIAS[0]['height'])+'p', MEDIAS[0]['url']
	if FINAL_URL and STREAM:
		LSM = xbmcgui.ListItem(path=FINAL_URL)
		LSM.setMimeType(MIME)
		if ADDON_operate('inputstream.adaptive') and STREAM in ['HLS', 'MPD']:
			LSM.setProperty(INPUT_APP, 'inputstream.adaptive')
			LSM.setProperty('inputstream.adaptive.manifest_type', STREAM.lower())
		xbmcplugin.setResolvedUrl(ADDON_HANDLE, True, LSM)
		log("(navigator.playVideo) [{0}] {1}_stream : {2} ".format(QUALITY, STREAM, FINAL_URL))
	else: 
		failing("(navigator.playVideo) ##### Die angeforderte Video-Url wurde leider NICHT gefunden !!! #####")
		return dialog.notification(translation(30521).format('STREAM'), translation(30527), icon, 8000)

def AddToQueue():
	return xbmc.executebuiltin('Action(Queue)')

def addDir(name, image, params={}, plot=None, folder=True):
	if params.get('extras') == 'YT_FOLDER': u = params.get('url')
	else: u = '{0}?{1}'.format(HOST_AND_PATH, urlencode(params))
	liz = xbmcgui.ListItem(name)
	if KODI_ov20:
		videoInfoTag = liz.getVideoInfoTag()
		videoInfoTag.setTitle(name), videoInfoTag.setPlot(plot), videoInfoTag.setStudios(['Der Spiegel'])
	else:
		liz.setInfo(type='Video', infoLabels={'Title': name, 'Plot': plot, 'Studio': 'Der Spiegel'})
	liz.setArt({'icon': icon, 'thumb': image, 'poster': image, 'fanart': defaultFanart})
	if image and useThumbAsFanart and image != icon and not artpic in image:
		liz.setArt({'fanart': image})
	return xbmcplugin.addDirectoryItem(handle=ADDON_HANDLE, url=u, listitem=liz, isFolder=folder)
